

<?php $__env->startSection('title', 'Create Appointment'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <h1 class="text-3xl font-bold text-gray-800">Create New Appointment</h1>
        <a href="<?php echo e(route('pharmacist.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <form method="POST" action="<?php echo e(route('pharmacist.appointments.store')); ?>" enctype="multipart/form-data" class="bg-white rounded-lg shadow p-6">
        <?php echo csrf_field(); ?>

        <!-- Patient Information -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Patient Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="md:col-span-2">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Select Existing Patient (Optional)</label>
                    <select name="patient_id" id="patient_id" class="w-full px-3 py-2 border rounded">
                        <option value="">-- Select Existing Patient or Create New --</option>
                        <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($patient->id); ?>" data-patient='<?php echo json_encode($patient, 15, 512) ?>'>
                                <?php echo e($patient->full_name); ?> (<?php echo e($patient->patient_id); ?>) - <?php echo e($patient->phone_number); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <p class="text-sm text-gray-600 mt-1">If you select an existing patient, their information will be auto-filled below.</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Branch *</label>
                    <select name="branch_id" required class="w-full px-3 py-2 border rounded">
                        <option value="">Select Branch</option>
                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Title</label>
                    <input type="text" name="title" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">First Name *</label>
                    <input type="text" name="first_name" id="first_name" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Last Name *</label>
                    <input type="text" name="last_name" id="last_name" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Date of Birth</label>
                    <input type="date" name="date_of_birth" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Gender</label>
                    <select name="gender" class="w-full px-3 py-2 border rounded">
                        <option value="">Select</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                        <option value="Other">Other</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Identity Number</label>
                    <input type="text" name="identity_number" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone Area Code</label>
                    <input type="text" name="phone_area_code" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone Number *</label>
                    <input type="text" name="phone_number" id="phone_number" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Email</label>
                    <input type="email" name="email" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Payment Mode *</label>
                    <select name="payment_mode" required class="w-full px-3 py-2 border rounded">
                        <option value="Cash Payment">Cash Payment</option>
                        <option value="Medical Aid Payment">Medical Aid Payment</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Medical Aid Number</label>
                    <input type="text" name="medical_aid_number" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Main Member</label>
                    <input type="text" name="main_member" class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <!-- Consultation Details -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Consultation Details</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Consulting Doctor</label>
                    <select name="doctor_id" id="doctor_id" class="w-full px-3 py-2 border rounded">
                        <option value="">Select Doctor</option>
                        <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($doctor->id); ?>"><?php echo e($doctor->full_name); ?> <?php if($doctor->specialization): ?>(<?php echo e($doctor->specialization); ?>)<?php endif; ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div id="doctor_availability_container" class="hidden">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Doctor Availability</label>
                    <div id="doctor_availability" class="bg-blue-50 p-4 rounded border border-blue-200">
                        <p class="text-sm text-gray-600">Loading availability...</p>
                    </div>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Consultation Type *</label>
                    <select name="consultation_type" required class="w-full px-3 py-2 border rounded">
                        <option value="Diagnostic Consultation">Diagnostic Consultation</option>
                        <option value="Remote Consultation">Remote Consultation</option>
                        <option value="Primary care Consultation">Primary care Consultation</option>
                        <option value="Mental health support">Mental health support</option>
                        <option value="Psychoanalytic or Psychodynamic Therapy">Psychoanalytic or Psychodynamic Therapy</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Appointment Type *</label>
                    <select name="appointment_type" id="appointment_type" required class="w-full px-3 py-2 border rounded">
                        <option value="scheduled">Book Appointment With a Doctor</option>
                        <option value="immediate">Consult Doctor Now</option>
                    </select>
                </div>

                <div id="appointment_date_field">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Appointment Date & Time</label>
                    <input type="datetime-local" name="appointment_date" class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <!-- Medical History -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Medical History</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Diagnosis/Allergies</label>
                    <textarea name="diagnosis_allergies" rows="3" class="w-full px-3 py-2 border rounded"></textarea>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Medicines if Taken</label>
                    <textarea name="medicines_taken" rows="3" class="w-full px-3 py-2 border rounded"></textarea>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Still Using</label>
                    <select name="still_using" class="w-full px-3 py-2 border rounded">
                        <option value="0">No</option>
                        <option value="1">Yes</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Additional Notes</label>
                    <textarea name="additional_notes" rows="3" class="w-full px-3 py-2 border rounded"></textarea>
                </div>
            </div>
        </div>

        <!-- Vitals -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Vitals</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Resp Pattern</label>
                    <input type="text" name="resp_pattern" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">SpO2 (%)</label>
                    <input type="number" step="0.01" name="spo2" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Temperature (°C)</label>
                    <input type="number" step="0.01" name="temperature" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Blood Pressure (mmHg)</label>
                    <input type="text" name="blood_pressure" placeholder="e.g., 120/80" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Pulse Rate (bpm)</label>
                    <input type="number" name="pulse_rate" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">RBS (%)</label>
                    <input type="number" step="0.01" name="rbs" class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <!-- Additional Notes -->
        <div class="mb-6 sm:mb-8">
            <label class="block text-gray-700 text-sm font-bold mb-2">Additional Medical Notes</label>
            <textarea name="additional_medical_notes" rows="4" class="w-full px-3 py-2 border rounded text-sm sm:text-base"></textarea>
        </div>

        <!-- Documents -->
        <div class="mb-6 sm:mb-8">
            <label class="block text-gray-700 text-sm font-bold mb-2">Attach Patient Documents</label>
            <input type="file" name="documents[]" multiple accept=".pdf,.jpg,.jpeg,.png" class="w-full px-3 py-2 border rounded text-sm sm:text-base">
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Max. file size: 10.6MB</p>
        </div>

        <!-- Signatures -->
        <div class="mb-6 sm:mb-8">
            <h2 class="text-xl sm:text-2xl font-bold mb-3 sm:mb-4">Signatures</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Pharmacist Signature *</label>
                    <input type="text" name="pharmacist_signature" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Client Signature *</label>
                    <input type="text" name="client_signature" required class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 sm:px-6 py-2 rounded text-sm sm:text-base w-full sm:w-auto">
                Submit
            </button>
        </div>
    </form>
</div>

<script>
document.getElementById('appointment_type').addEventListener('change', function() {
    const dateField = document.getElementById('appointment_date_field');
    if (this.value === 'immediate') {
        dateField.style.display = 'none';
    } else {
        dateField.style.display = 'block';
    }
});

// Patient selection handler
document.getElementById('patient_id').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    if (selectedOption.value && selectedOption.dataset.patient) {
        const patient = JSON.parse(selectedOption.dataset.patient);
        document.getElementById('first_name').value = patient.first_name || '';
        document.getElementById('last_name').value = patient.last_name || '';
        document.getElementById('phone_number').value = patient.phone_number || '';
        document.querySelector('input[name="title"]').value = patient.title || '';
        document.querySelector('input[name="date_of_birth"]').value = patient.date_of_birth || '';
        document.querySelector('select[name="gender"]').value = patient.gender || '';
        document.querySelector('input[name="identity_number"]').value = patient.identity_number || '';
        document.querySelector('input[name="phone_area_code"]').value = patient.phone_area_code || '';
        document.querySelector('input[name="email"]').value = patient.email || '';
        document.querySelector('select[name="payment_mode"]').value = patient.payment_mode || '';
        document.querySelector('input[name="medical_aid_number"]').value = patient.medical_aid_number || '';
        document.querySelector('input[name="main_member"]').value = patient.main_member || '';
    } else {
        // Clear fields if no patient selected
        document.getElementById('first_name').value = '';
        document.getElementById('last_name').value = '';
        document.getElementById('phone_number').value = '';
    }
});

// Doctor availability handler
document.getElementById('doctor_id').addEventListener('change', function() {
    const doctorId = this.value;
    const availabilityContainer = document.getElementById('doctor_availability_container');
    const availabilityDiv = document.getElementById('doctor_availability');
    
    if (doctorId) {
        availabilityContainer.classList.remove('hidden');
        availabilityDiv.innerHTML = '<p class="text-sm text-gray-600">Loading availability...</p>';
        
        fetch(`/pharmacist/doctor-availability/${doctorId}`, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            let html = '<div class="space-y-2">';
            
            if (data.availabilities && data.availabilities.length > 0) {
                html += '<p class="font-semibold text-sm mb-2">Available Times:</p>';
                data.availabilities.forEach(avail => {
                    const dayName = avail.day_of_week.charAt(0).toUpperCase() + avail.day_of_week.slice(1);
                    html += `<div class="text-sm">
                        <span class="font-medium">${dayName}:</span> 
                        ${avail.start_time} - ${avail.end_time}
                    </div>`;
                });
            } else {
                html += '<p class="text-sm text-yellow-600">No availability schedule set. Doctor may be available on request.</p>';
            }
            
            if (data.booked_slots && data.booked_slots.length > 0) {
                html += '<p class="font-semibold text-sm mt-3 mb-2">Booked Appointments:</p>';
                html += '<p class="text-xs text-gray-600">' + data.booked_slots.length + ' appointment(s) scheduled</p>';
            }
            
            html += '</div>';
            availabilityDiv.innerHTML = html;
        })
        .catch(error => {
            availabilityDiv.innerHTML = '<p class="text-sm text-red-600">Error loading availability</p>';
            console.error('Error:', error);
        });
    } else {
        availabilityContainer.classList.add('hidden');
    }
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/pharmacist/create-appointment.blade.php ENDPATH**/ ?>